function y = flocmaxima (x,ws,mask)
% y = flocmaxima (x,ws,mask)
%
% Find the local maxima in an image. Only maxima within the area defined
% by a binary mask are considered.
%
% In:
%  x     image
%  ws    window size for finding the local maxima
%  mask  binary mask
%
% Out:
%  y     binary image with the maxima marked as ones
%
% Antti Niemist 2006/08/01

[height width] = size (x);

if nargin == 2
  mask = ones(size(height,width));
end

ws = (ws-1)/2;				% This is more useful
xx = zeros (height+2*ws,width+2*ws);	% Expand x
xx(1+ws:height+ws,1+ws:width+ws) = x;	% Put x in the middle of xx

% Perform actual filtering in a double loop.
y = zeros (size (x));
for i = 1:height
  for j = 1:width
    if mask(i,j) == 0
      continue
    end
    window = xx(i:i+2*ws,j:j+2*ws);	% Form the window
    if max(window(:)) == window(ws+1,ws+1);
      y(i,j) = 1;
    end
  end
end
